/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model;

import static java.util.Collections.emptyList;
import static java.util.Collections.unmodifiableList;

import java.util.ArrayList;
import java.util.List;

public class ClassValueModel {

  private final List<String> assignableFrom;

  public ClassValueModel(List<String> assignableFrom) {
    if (assignableFrom != null && !assignableFrom.isEmpty()) {
      this.assignableFrom = unmodifiableList(new ArrayList<>(assignableFrom));
    } else {
      this.assignableFrom = emptyList();
    }
  }

  public List<String> getAssignableFrom() {
    return assignableFrom;
  }
}
