/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.dataweave;

import org.mule.tooling.client.api.dataweave.validation.DataWeaveValidationRequest;
import org.mule.tooling.client.api.el.ValidationResult;

import java.util.List;

/**
 * Service for DataWeave operations.
 *
 * @since 1.0
 */
public interface DataWeaveService {

  /**
   * Returns the result of dataweave script execution.
   *
   * @param parameters required data to execute dw script.
   * @return Execution response with details. Successful execution result in the given mimeType. not successful execution will
   *         provide execution details.
   */
  DataWeavePreviewResponse execute(DataWeavePreviewRequest parameters);

  /**
   * Returns the result of dataweave script validation.
   *
   * @param request required data to validate dw script.
   * @return Validation response indicating any errors during compilation .
   */
  ValidationResult validate(DataWeaveValidationRequest request);

  /**
   * Returns list of {@link DataWeaveModuleOption} that represents DataWeave Module Reader configurations.
   *
   * @param contentType represents module to be queried.
   * @return module reader configurations.
   */
  List<DataWeaveModuleOption> getReaderOptions(String contentType);

  /**
   * Returns list of {@link DataWeaveModuleOption} that represents DataWeave Module Writer configurations.
   *
   * @param contentType represents module to be queried.
   * @return module writer configurations.
   */
  List<DataWeaveModuleOption> getWriterOptions(String contentType);
}
