/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense.storage;


import org.mule.tooling.client.api.cache.CacheStorage;
import org.mule.tooling.client.api.cache.CacheStorageFactory;
import org.mule.tooling.client.api.cache.CacheStorageFactoryContext;
import org.mule.tooling.client.internal.metadata.DefaultMetadataCacheStorageFactoryContext;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * Factory for {@link MetadataCacheStorage}.
 */
public interface MetadataCacheStorageFactory extends CacheStorageFactory {

  /**
   * Create a {@link MetadataCacheStorage}
   *
   * @param context a {@link MetadataCacheStorageFactoryContext} with information used to build a {@link MetadataCacheStorage}
   * @return {@link MetadataCacheStorage}.
   * @deprecated use {@link CacheStorageFactory#createCacheStorage(CacheStorageFactoryContext)}
   */
  @Deprecated
  MetadataCacheStorage createMetadataCache(MetadataCacheStorageFactoryContext context);

  @Override
  default CacheStorage createCacheStorage(CacheStorageFactoryContext context) {
    return createMetadataCache(
                               new DefaultMetadataCacheStorageFactoryContext(
                                                                             context.getToolingArtifactId(),
                                                                             context.getArtifactContentUrl(),
                                                                             context.getToolingArtifactProperties(),
                                                                             new MetadataCacheStorageSerializer() {

                                                                               @Override
                                                                               public void serialize(OutputStream outputStream,
                                                                                                     Object object) {
                                                                                 context.getStorageSerializer()
                                                                                     .serialize(outputStream, object);
                                                                               }

                                                                               @Override
                                                                               public <T> T deserialize(InputStream serialized) {
                                                                                 return context.getStorageSerializer()
                                                                                     .deserialize(serialized);
                                                                               }
                                                                             }));
  }
}
