/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Declares the type of notification for {@link DataSenseNotification}.
 *
 * @since 1.0
 */
public class DataSenseNotificationType extends UnknownType {

  private boolean fatalError = false;
  private boolean error = false;
  private boolean warning = false;
  private boolean info = false;

  private DataSenseNotificationType() {}

  public DataSenseNotificationType(String name) {
    super(name);
  }

  public boolean equals(Object other) {
    if (!(other instanceof DataSenseNotificationType)) {
      return false;
    }

    return this.getValue().equals(((DataSenseNotificationType) other).getValue());
  }

  public static DataSenseNotificationType fatalErrorDataSenseNotificationType(String name) {
    DataSenseNotificationType type = new DataSenseNotificationType(name);
    type.fatalError = true;
    return type;
  }

  public static DataSenseNotificationType errorDataSenseNotificationType(String name) {
    DataSenseNotificationType type = new DataSenseNotificationType(name);
    type.error = true;
    return type;
  }

  public static DataSenseNotificationType warningDataSenseNotificationType(String name) {
    DataSenseNotificationType type = new DataSenseNotificationType(name);
    type.warning = true;
    return type;
  }

  public static DataSenseNotificationType infoDataSenseNotificationType(String name) {
    DataSenseNotificationType type = new DataSenseNotificationType(name);
    type.info = true;
    return type;
  }

  public boolean isError() {
    return error;
  }

  public boolean isFatalError() {
    return fatalError;
  }

  public boolean isInfo() {
    return info;
  }

  public boolean isWarning() {
    return warning;
  }

}
