/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.component.location;

import static com.google.common.collect.ImmutableSet.copyOf;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ArtifactComponentLocations implements Serializable {

  private final Set<ComponentLocation> componentLocations;
  private final Map<SourceCodeLocation, ComponentLocation> sourceCodeLocationToComponentLocation = new HashMap<>();
  private final Map<String, ComponentLocation> pathToComponentLocation = new HashMap<>();

  public ArtifactComponentLocations(Set<ComponentLocation> componentLocations) {
    this.componentLocations = copyOf(componentLocations);
    componentLocations.forEach(componentLocation -> {
      componentLocation.getSourceCodeLocation()
          .ifPresent(sourceCodeLocation -> sourceCodeLocationToComponentLocation.put(sourceCodeLocation, componentLocation));
      pathToComponentLocation.put(componentLocation.getLocation(), componentLocation);
    });
  }

  public Set<ComponentLocation> getComponentLocations() {
    return componentLocations;
  }

  public ComponentLocation getBySourceCodeLocation(SourceCodeLocation sourceCodeLocation) {
    return sourceCodeLocationToComponentLocation.get(sourceCodeLocation);
  }

  public ComponentLocation getByLocation(String location) {
    return pathToComponentLocation.get(location);
  }
}
