/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.dsl.request;

import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverFactory;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;

import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * Request entity for obtaining a {@link DslSyntaxResolverFactory} in the context provided by {@code this} request.
 *
 * @since 1.0
 */
public class DslSyntaxResolverFactoryRequest {

  private final List<ArtifactDescriptor> pluginArtifactDescriptors;

  public DslSyntaxResolverFactoryRequest(List<ArtifactDescriptor> plugins) {
    pluginArtifactDescriptors = plugins == null ? ImmutableList.of() : ImmutableList.copyOf(plugins);
  }

  public List<ArtifactDescriptor> getPluginArtifactDescriptors() {
    return pluginArtifactDescriptors;
  }
}
