/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.declaration.request;

import static java.util.Collections.emptyList;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.request.AbstractToolingRequest;

import java.util.List;

/**
 * Base class for {@link org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService} related requests.
 *
 * @since 1.0
 */
public abstract class AbstractXmlArtifactRequest extends AbstractToolingRequest {

  private List<ArtifactDescriptor> pluginArtifactDescriptors = emptyList();

  /**
   * Creates a new instance of an {@link AbstractXmlArtifactRequest}
   *
   * @param pluginArtifactDescriptors {@link ArtifactDescriptor artifacts} {@link List} needed by the declaration.
   */
  AbstractXmlArtifactRequest(List<ArtifactDescriptor> pluginArtifactDescriptors) {
    this.pluginArtifactDescriptors = pluginArtifactDescriptors;
  }

  /**
   * @return the {@link ArtifactDescriptor artifacts} {@link List} needed by the declaration
   */
  public List<ArtifactDescriptor> getPluginArtifactDescriptors() {
    return pluginArtifactDescriptors;
  }

}
