/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.configuration.ssl;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.tooling.client.api.configuration.ssl.TrustStoreConfig;

import java.io.File;

/**
 * Immutable implementation of {@link TrustStoreConfig}.
 *
 * @since 1.0
 */
public class ImmutableTrustStoreConfig implements TrustStoreConfig {

  private final File trustStoreFile;
  private final String trustStorePassword;

  /**
   * Creates an instance of this configuration.
   *
   * @param trustStoreFile     trust store {@link File}.
   * @param trustStorePassword trust store password.
   */
  public ImmutableTrustStoreConfig(File trustStoreFile, String trustStorePassword) {
    requireNonNull(trustStoreFile, "trustStoreFile cannot be null");
    requireNonNull(trustStorePassword, "trustStorePassword cannot be null");

    this.trustStoreFile = trustStoreFile;
    this.trustStorePassword = trustStorePassword;
  }

  @Override
  public File getTrustStoreFile() {
    return trustStoreFile;
  }

  @Override
  public String getTrustStorePassword() {
    return trustStorePassword;
  }

  @Override
  public String toString() {
    return format("%s{trustStoreFile=%s, trustStorePassword=%s}",
                  getShortClassName(this.getClass()), trustStoreFile.getAbsolutePath(), "****");
  }

}
