/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.component.location;

import java.util.Objects;

/**
 * The location of the components in the configuration file.
 */
public class SourceCodeLocation {

  private String fileName;
  private Integer startLine;
  private Integer startColumn;
  private Integer endLine;
  private Integer endColumn;

  private SourceCodeLocation() {}

  public SourceCodeLocation(String fileName, Integer startLine, Integer startColumn) {
    this(fileName, startLine, startLine, startColumn, startColumn);
  }

  public SourceCodeLocation(String fileName, Integer startLine, Integer endLine, Integer startColumn, Integer endColumn) {
    this.fileName = fileName;
    this.startLine = startLine;
    this.endLine = endLine;
    this.startColumn = startColumn;
    this.endColumn = endColumn;
  }

  /**
   * @return the file which contains the component
   */
  public String getFileName() {
    return fileName;
  }

  /**
   * @return the line in which the component starts within the file.
   */
  public Integer getStartLine() {
    return startLine;
  }

  /**
   * @return the line in which the component ends within the file.
   */
  public Integer getEndLine() {
    return endLine;
  }

  /**
   * @return the column in which the component starts within the file.
   */
  public Integer getStartColumn() {
    return startColumn;
  }

  /**
   * @return the column in which the component ends within the file.
   */
  public Integer getEndColumn() {
    return endColumn;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SourceCodeLocation that = (SourceCodeLocation) o;
    return Objects.equals(getFileName(), that.getFileName()) &&
        Objects.equals(getStartLine(), that.getStartLine()) &&
        Objects.equals(getEndLine(), that.getEndLine()) &&
        Objects.equals(getStartColumn(), that.getStartColumn()) &&
        Objects.equals(getEndColumn(), that.getEndColumn());
  }

  @Override
  public int hashCode() {
    return Objects.hash(getFileName(), getStartLine(), getStartLine(), getStartColumn(), getEndLine());
  }

  @Override
  public String toString() {
    return this.getClass().getName() + "{" + fileName + ":"
        + startLine + "-" + endLine + ":"
        + startColumn + "-" + endColumn
        + "}";
  }
}
