/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.declaration.request;

import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;

import java.util.List;

/**
 * Request entity for obtaining a serialized representation of the given {@link ArtifactDeclaration}
 *
 * @since 1.0
 */
public final class XmlArtifactSerializationRequest extends AbstractXmlArtifactRequest {

  private ArtifactDeclaration artifactDeclaration;

  /**
   * Creates a new instance of an {@link XmlArtifactSerializationRequest}
   * 
   * @param artifactDeclaration       the {@link ArtifactDeclaration} to be serialized
   *                                  {@link org.mule.tooling.client.api.extension.model.ExtensionModel}s information for the
   *                                  conversion to be done.
   * @param pluginArtifactDescriptors {@link ArtifactDescriptor artifacts} {@link List} needed by the declaration.
   */
  public XmlArtifactSerializationRequest(ArtifactDeclaration artifactDeclaration,
                                         List<ArtifactDescriptor> pluginArtifactDescriptors) {
    super(pluginArtifactDescriptors);
    this.artifactDeclaration = artifactDeclaration;
  }

  /**
   * @return the {@link ArtifactDeclaration} to be serialized converted
   */
  public ArtifactDeclaration getArtifactDeclaration() {
    return artifactDeclaration;
  }

}

