/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.configuration.agent;

import static java.lang.String.format;
import static java.util.Optional.ofNullable;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.configuration.agent.proxy.ProxyConfig;
import org.mule.tooling.client.api.configuration.ssl.SslConfiguration;

import java.net.URL;
import java.util.Optional;

/**
 * Immutable implementation for {@link AgentConfiguration}.
 *
 * @since 1.0
 */
public class ImmutableAgentConfiguration implements AgentConfiguration {

  private URL toolingApiUrl;
  private long defaultConnectionTimeout;
  private long defaultReadTimeout;
  private SslConfiguration sslConfiguration;
  private String muleVersion;
  private ProxyConfig proxyConfig;
  private String authorizationToken;

  public ImmutableAgentConfiguration(URL toolingApiUrl,
                                     long defaultConnectionTimeout,
                                     long defaultReadTimeout,
                                     SslConfiguration sslConfiguration,
                                     String muleVersion,
                                     ProxyConfig proxyConfig,
                                     String authorizationToken) {
    this.toolingApiUrl = toolingApiUrl;
    this.defaultConnectionTimeout = defaultConnectionTimeout;
    this.defaultReadTimeout = defaultReadTimeout;
    this.sslConfiguration = sslConfiguration;
    this.muleVersion = muleVersion;
    this.proxyConfig = proxyConfig;
    this.authorizationToken = authorizationToken;
  }

  @Override
  public URL getToolingApiUrl() {
    return toolingApiUrl;
  }

  @Override
  public long getDefaultConnectTimeout() {
    return defaultConnectionTimeout;
  }

  @Override
  public long getDefaultReadTimeout() {
    return defaultReadTimeout;
  }

  @Override
  public Optional<String> muleVersion() {
    return ofNullable(muleVersion);
  }

  @Override
  public Optional<SslConfiguration> getSslConfiguration() {
    return ofNullable(this.sslConfiguration);
  }

  @Override
  public Optional<ProxyConfig> getProxyConfig() {
    return ofNullable(proxyConfig);
  }

  @Override
  public String getAuthorizationToken() {
    return this.authorizationToken;
  }

  @Override
  public String toString() {
    return format("%s{toolingApiUrl=%s,defaultConnectionTimeout=%sms, defaultReadTimeout=%sms, muleVersion=%s, proxyConfig=%s}",
                  getShortClassName(this.getClass()), toolingApiUrl, defaultConnectionTimeout, defaultReadTimeout,
                  muleVersion != null ? muleVersion : "", proxyConfig);
  }

}
