/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense.storage;

import org.mule.api.annotation.NoImplement;
import org.mule.tooling.client.api.cache.CacheStorageSerializer;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * Serializer used to serialize and deserialize objects used in a {@link MetadataCacheStorage} in case it's needed.
 * <p/>
 * It's very important that serialized objects are not modified in any way in order to be able to deserialize them. That means
 * that, the same bytes that are written to the {@link OutputStream} when serializing, should be read from the {@link InputStream}
 * when deserializing.
 *
 * @since 1.2.2, 1.3.0
 */
@NoImplement
public interface MetadataCacheStorageSerializer extends CacheStorageSerializer {

}
