/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.metadata.persistence.SerializationContext;
import org.mule.metadata.persistence.type.adapter.OptionalTypeAdapterFactory;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.ImportedTypeModel;
import org.mule.tooling.client.internal.persistence.ErrorModelToIdentifierTypeAdapter;
import org.mule.tooling.client.internal.persistence.ExtensionModelTypeAdapter;
import org.mule.tooling.client.internal.persistence.MetadataTypeAdapterFactory;
import org.mule.tooling.client.internal.persistence.NestableElementModelTypeAdapterFactory;
import org.mule.tooling.client.internal.persistence.RestrictedTypesObjectTypeReferenceHandler;

public final class ExtensionModelJsonSerializer {
    private boolean prettyPrint;
    private Set<ObjectType> registeredTypes = Collections.emptySet();
    private Set<ObjectType> importedTypes = Collections.emptySet();
    private boolean refErrorModels = false;

    public ExtensionModelJsonSerializer() {
        this(false);
    }

    public ExtensionModelJsonSerializer(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    private Gson buildGson() {
        final HashMap<String, ErrorModel> errorModelRepository = new HashMap<String, ErrorModel>();
        final SerializationContext serializationContext = new SerializationContext();
        final Gson gsonDelegate = this.gsonBuilder(serializationContext, this.prettyPrint, errorModelRepository).create();
        return this.gsonBuilder(serializationContext, this.prettyPrint, errorModelRepository).registerTypeAdapterFactory(new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (ExtensionModel.class.isAssignableFrom(type.getRawType())) {
                    return new ExtensionModelTypeAdapter(gsonDelegate, serializationContext, errorModelRepository);
                }
                return null;
            }
        }).create();
    }

    private GsonBuilder gsonBuilder(SerializationContext serializationContext, boolean prettyPrint, Map<String, ErrorModel> errorModelRepository) {
        Set<String> registeredTypeIds = this.registeredTypes.stream().map(JavaTypeUtils::getId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.importedTypes.forEach(type -> {
            JavaTypeUtils.getId((MetadataType)type).ifPresent(registeredTypeIds::add);
            serializationContext.registerObjectType(type);
        });
        RestrictedTypesObjectTypeReferenceHandler referenceHandler = new RestrictedTypesObjectTypeReferenceHandler(serializationContext, registeredTypeIds);
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new MetadataTypeAdapterFactory(referenceHandler)).registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new NestableElementModelTypeAdapterFactory());
        if (this.refErrorModels) {
            gsonBuilder.registerTypeAdapter(ErrorModel.class, (Object)new ErrorModelToIdentifierTypeAdapter(errorModelRepository));
        }
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder;
    }

    public String serialize(ExtensionModel extensionModel) {
        this.registeredTypes = extensionModel.getTypes();
        this.importedTypes = extensionModel.getImportedTypes().stream().map(ImportedTypeModel::getImportedType).collect(Collectors.toSet());
        return this.buildGson().toJson((Object)extensionModel);
    }

    public String serializeList(List<ExtensionModel> extensionModelList) {
        return this.buildGson().toJson(extensionModelList);
    }

    public ExtensionModel deserialize(String extensionModel) {
        return (ExtensionModel)this.buildGson().fromJson(extensionModel, ExtensionModel.class);
    }

    public List<ExtensionModel> deserializeList(String extensionModelList) {
        return (List)this.buildGson().fromJson(extensionModelList, new TypeToken<List<ExtensionModel>>(){}.getType());
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean prettyPrint = false;
        private boolean refErrorModels = false;

        public Builder setPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder refErrorModels(boolean refErrorModels) {
            this.refErrorModels = refErrorModels;
            return this;
        }

        public ExtensionModelJsonSerializer build() {
            ExtensionModelJsonSerializer extensionModelJsonSerializer = new ExtensionModelJsonSerializer();
            extensionModelJsonSerializer.prettyPrint = this.prettyPrint;
            extensionModelJsonSerializer.refErrorModels = this.refErrorModels;
            return extensionModelJsonSerializer;
        }
    }
}

