/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.sampledata;

import org.mule.tooling.client.api.sampledata.request.SampleDataRequest;

/**
 * Provides the capability of obtain a {@link ComponentSampleDataResult} for any Sample Data Provider available in a Mule App.
 *
 * @since 1.4
 */
public interface SampleDataService {

  /**
   * Retrieve sample data for the component
   *
   * @param sampleDataRequest a {@link SampleDataRequest} with all the required information to execute this request
   * @return a {@link ComponentSampleDataResult} with the sample data
   */
  ComponentSampleDataResult getSampleData(SampleDataRequest sampleDataRequest);

}
