/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.metadata;

import static java.util.Optional.ofNullable;
import org.mule.metadata.api.model.MetadataType;

import java.util.Map;
import java.util.Optional;

/**
 * Container for metadata obtained from a component, input, output and attributes.
 *
 * @since 1.4
 */
public class ComponentMetadataTypesDescriptor {

  private Map<String, MetadataType> inputMetadata;
  private MetadataType outputMetadata;
  private MetadataType outputAttributesMetadata;

  public ComponentMetadataTypesDescriptor() {}

  public ComponentMetadataTypesDescriptor(Map<String, MetadataType> inputMetadata, MetadataType outputMetadata,
                                          MetadataType outputAttributesMetadata) {
    this.inputMetadata = inputMetadata;
    this.outputMetadata = outputMetadata;
    this.outputAttributesMetadata = outputAttributesMetadata;
  }

  public Map<String, MetadataType> getInputMetadata() {
    return inputMetadata;
  }

  public MetadataType getInputMetadata(String parameterName) {
    return inputMetadata != null ? inputMetadata.get(parameterName) : null;
  }

  public void setInputMetadata(Map<String, MetadataType> inputMetadata) {
    this.inputMetadata = inputMetadata;
  }

  public Optional<MetadataType> getOutputMetadata() {
    return ofNullable(outputMetadata);
  }

  public void setOutputMetadata(MetadataType outputMetadata) {
    this.outputMetadata = outputMetadata;
  }

  public Optional<MetadataType> getOutputAttributesMetadata() {
    return ofNullable(outputAttributesMetadata);
  }

  public void setOutputAttributesMetadata(MetadataType outputAttributesMetadata) {
    this.outputAttributesMetadata = outputAttributesMetadata;
  }
}
