/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.datasense;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.datasense.DataSenseNotification;

public class DataSenseElementInfo {
    private MetadataType input;
    private MetadataType output;
    private MetadataType income;
    private MetadataType expected;
    private MetadataType actualInput;
    private MetadataType actualOutput;
    private MetadataType expectedInput;
    private MetadataType expectedOutput;
    private MetadataType result;
    private List<String> messages;
    private Location location;
    private List<DataSenseNotification> notifications;

    public Location getLocation() {
        return this.location;
    }

    public Optional<MetadataType> getInput() {
        return Optional.ofNullable(this.input);
    }

    public Optional<MetadataType> getOutput() {
        return Optional.ofNullable(this.output);
    }

    public Optional<MetadataType> getIncoming() {
        return Optional.ofNullable(this.income);
    }

    public Optional<MetadataType> getExpected() {
        return Optional.ofNullable(this.expected);
    }

    public Optional<MetadataType> getActualInput() {
        return Optional.ofNullable(this.actualInput);
    }

    public Optional<MetadataType> getActualOutput() {
        return Optional.ofNullable(this.actualOutput);
    }

    public Optional<MetadataType> getExpectedInput() {
        return Optional.ofNullable(this.expectedInput);
    }

    public Optional<MetadataType> getExpectedOutput() {
        return Optional.ofNullable(this.expectedOutput);
    }

    public Optional<MetadataType> getResult() {
        return Optional.ofNullable(this.result);
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public List<DataSenseNotification> getDataSenseNotifications() {
        return this.notifications;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        DataSenseElementInfo dataSenseElementInfo = new DataSenseElementInfo();

        public Builder withLocation(Location location) {
            this.dataSenseElementInfo.location = location;
            return this;
        }

        public Builder withInput(MetadataType input) {
            this.dataSenseElementInfo.input = input;
            return this;
        }

        public Builder withOutput(MetadataType output) {
            this.dataSenseElementInfo.output = output;
            return this;
        }

        public Builder withIncoming(MetadataType income) {
            this.dataSenseElementInfo.income = income;
            return this;
        }

        public Builder withExpected(MetadataType expected) {
            this.dataSenseElementInfo.expected = expected;
            return this;
        }

        public Builder withActualInput(MetadataType actualInput) {
            this.dataSenseElementInfo.actualInput = actualInput;
            return this;
        }

        public Builder withActualOutput(MetadataType actualOutput) {
            this.dataSenseElementInfo.actualOutput = actualOutput;
            return this;
        }

        public Builder withExpectedInput(MetadataType expectedInput) {
            this.dataSenseElementInfo.expectedInput = expectedInput;
            return this;
        }

        public Builder withExpectedOutput(MetadataType expectedOutput) {
            this.dataSenseElementInfo.expectedOutput = expectedOutput;
            return this;
        }

        public Builder withResult(MetadataType result) {
            this.dataSenseElementInfo.result = result;
            return this;
        }

        public Builder withMessages(List<String> messages) {
            this.dataSenseElementInfo.messages = messages;
            return this;
        }

        public Builder withNotifications(List<DataSenseNotification> notifications) {
            this.dataSenseElementInfo.notifications = notifications;
            return this;
        }

        public DataSenseElementInfo build() {
            return this.dataSenseElementInfo;
        }
    }
}

