/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.cache;

import java.net.URL;
import java.util.Map;

/**
 * Factory for a {@link Map} that wraps a {@link org.mule.tooling.client.api.cache.CacheStorage}
 * <p>
 * This should be used internally to avoid serialization between class loaders. Since the storage is wrapped by a Map, it will be
 * loaded by all class loaders and methods can be called freely without requiring reflection.
 *
 * @since 1.3.0
 */
public interface CacheStorageMapWrapperFactory {

  /***
   * @param toolingArtifactId
   * @param artifactContentUrl
   * @param properties
   * @return a {@link Map} that represents a {@link org.mule.tooling.client.api.cache.CacheStorage}
   */
  Map<String, ?> create(String toolingArtifactId, URL artifactContentUrl, Map<String, String> properties);

}
