/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.request;

import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.exception.TimeoutException;

/**
 * Base abstract classes for {@link ToolingArtifact} operations.
 *
 * @since 1.0
 */
public abstract class AbstractToolingRequest {

  private long requestTimeout = -1;

  /**
   * Sets the timeout in milliseconds for the request to be executed, if operation is not completed before timeout is reached a
   * {@link TimeoutException} is thrown by the operation. Default value is 0 (infinity).
   *
   * @param requestTimeout
   */
  public void setRequestTimeout(long requestTimeout) {
    checkArgument(requestTimeout > 0, "requestTimeout cannot be <= 0");
    this.requestTimeout = requestTimeout;
  }

  /**
   * @return timeout in milliseconds for the request to be executed, if operation is not completed before timeout is reached a
   *         {@link TimeoutException} is thrown by the operation. Default value is 0 (infinity).
   */
  public long getRequestTimeout() {
    return requestTimeout;
  }

  protected static void checkArgument(boolean expression, Object errorMessage) {
    if (!expression) {
      throw new IllegalArgumentException(String.valueOf(errorMessage));
    }
  }

}
