/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.datasense;

import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.datasense.DataSenseResolutionScope;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.internal.datasense.DataSenseResolutionScopeVisitor;

public class ComponentResolutionScope
implements DataSenseResolutionScope {
    private final Location location;
    private Feature<Boolean> keyEnrichment;

    public ComponentResolutionScope(Location location) {
        Objects.requireNonNull(location, "location cannot be null");
        this.location = location;
    }

    public ComponentResolutionScope(Location location, boolean keyEnrichment) {
        this(location);
        this.keyEnrichment = Feature.enabled(keyEnrichment);
    }

    public Location getLocation() {
        return this.location;
    }

    public Feature<Boolean> keyEnrichment() {
        if (this.keyEnrichment == null) {
            this.keyEnrichment = Feature.enabled(true);
        }
        return this.keyEnrichment;
    }

    public String toString() {
        return String.format("%s{location=%s, }", ClassUtils.getShortClassName(this.getClass()), this.getLocation());
    }

    @Override
    public void accept(DataSenseResolutionScopeVisitor visitor) {
        visitor.visit(this);
    }
}

