/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.util;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.function.Function;

/**
 * Utilities for functional programming
 *
 * @since 1.2
 */
public class FunctionalUtils {

  /**
   * Use this method instead if {@link Map#computeIfAbsent(Object, Function)} when the mapping functions are recursive and/or
   * will end up accessing the same {@code map} again. This is necessary because starting with JDK9
   * {@link Map#computeIfAbsent(Object, Function)} throws {@link ConcurrentModificationException} if used in concurrent,
   * recursive, or nested fashion.
   */
  public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<K, V> mappingFunction) {
    V value = map.get(key);
    if (value == null) {
      value = mappingFunction.apply(key);
      map.put(key, value);
    }
    return value;
  }
}
