/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.datasense;

import org.mule.tooling.client.api.datasense.ApplicationResolutionScope;
import org.mule.tooling.client.api.datasense.ComponentResolutionScope;
import org.mule.tooling.client.api.datasense.ConfigResolutionScope;
import org.mule.tooling.client.api.datasense.DataSenseResolutionScope;

/**
 * Visitor for {@link DataSenseResolutionScope}.
 *
 * @since 1.0
 */
public interface DataSenseResolutionScopeVisitor {

  void visit(ApplicationResolutionScope resolutionScope);

  void visit(ConfigResolutionScope resolutionScope);

  void visit(ComponentResolutionScope resolutionScope);

}
