/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Represents the different types of external libraries an extension may require.
 *
 * @since 1.0
 */
public class ExternalLibraryType extends UnknownType {

  private boolean nativeLibrary = false;
  private boolean jar = false;
  private boolean dependency = false;

  // Just needed in order to serialize this object
  private ExternalLibraryType() {}

  public ExternalLibraryType(String value) {
    super(value);
  }

  public static ExternalLibraryType nativeExternalLibraryType(String value) {
    ExternalLibraryType type = new ExternalLibraryType(value);
    type.nativeLibrary = true;
    return type;
  }

  public static ExternalLibraryType jarExternalLibraryType(String value) {
    ExternalLibraryType type = new ExternalLibraryType(value);
    type.jar = true;
    return type;
  }

  public static ExternalLibraryType dependencyExternalLibraryType(String value) {
    ExternalLibraryType type = new ExternalLibraryType(value);
    type.dependency = true;
    return type;
  }

  /**
   * @return {@code true} if native library.
   */
  public boolean isNativeLibrary() {
    return nativeLibrary;
  }

  /**
   * @return {@code true} if jar file.
   */
  public boolean isJar() {
    return jar;
  }

  /**
   * @return {@code true} if external dependencies.
   */
  public boolean isDependency() {
    return dependency;
  }

}
