/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.connectivity;

import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;

/**
 * Service for doing connectivity testing.
 *
 * A {@code ConnectivityTestingService}
 *
 * @since 1.0
 */
public interface ConnectivityTestingService {

  /**
   * Tests the connection defined for the given {@code componentId}.
   *
   * @param connectivityTestingRequest {@link ConnectivityTestingRequest} identifies a global element from the application configuration.
   * @return {@link ConnectionValidationResult} representing the result of the test.
   * @throws NoSuchApplicationException                    if the application is not deployed or was disposed.
   * @throws UnsupportedConnectivityTestingObjectException when it's not possible to do connectivity testing over the mule
   *                                                       component.
   * @throws ConnectivityTestingObjectNotFoundException    when the object to use to do connectivity does not exists
   * @throws ServiceUnavailableException                   if a connection exception happens when trying to connect to Mule Agent REST API.
   * @throws ToolingException                              if an unexpected error happens.
   */
  ConnectionValidationResult testConnection(ConnectivityTestingRequest connectivityTestingRequest)
      throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException,
      ConnectivityTestingObjectNotFoundException, ServiceUnavailableException;

}
