/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageFactoryContext;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageSerializer;

import java.net.URL;
import java.util.Map;

public class DefaultMetadataCacheStorageFactoryContext implements MetadataCacheStorageFactoryContext {

  private String toolingArtifactId;
  private URL artifactContentUrl;
  private Map<String, String> toolingArtifactProperties;
  private MetadataCacheStorageSerializer valueSerializer;

  public DefaultMetadataCacheStorageFactoryContext(String toolingArtifactId,
                                                   URL artifactContentUrl,
                                                   Map<String, String> toolingArtifactProperties,
                                                   MetadataCacheStorageSerializer valueSerializer) {
    this.toolingArtifactId = toolingArtifactId;
    this.artifactContentUrl = artifactContentUrl;
    this.toolingArtifactProperties = toolingArtifactProperties;
    this.valueSerializer = valueSerializer;
  }

  @Override
  public String getToolingArtifactId() {
    return toolingArtifactId;
  }

  @Override
  public URL getArtifactContentUrl() {
    return artifactContentUrl;
  }

  @Override
  public Map<String, String> getToolingArtifactProperties() {
    return toolingArtifactProperties;
  }

  @Override
  public MetadataCacheStorageSerializer getValueSerializer() {
    return valueSerializer;
  }
}
