/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense;

import java.util.Optional;

/**
 * Service for resolving data sense.
 * <p>
 * A {@code DataSenseService}
 *
 * @since 1.0
 */
public interface DataSenseService {

  /**
   * Resolves data sense for the {@link org.mule.tooling.client.api.component.location.Location}.
   *
   * @param dataSenseRequest {@link DataSenseRequest} defines the location of the element to be resolved.
   * @return {@link Optional} {@link DataSenseInfo} with the result.
   */
  Optional<DataSenseInfo> resolveDataSense(DataSenseRequest dataSenseRequest);

  /**
   * Resolves data sense component information for the {@link org.mule.tooling.client.api.component.location.Location}.
   *
   * @param dataSenseRequest {@link DataSenseRequest} defines the location of the element to be resolved.
   * @return {@link Optional} {@link DataSenseComponentInfo} with the result.
   */
  Optional<DataSenseComponentInfo> resolveComponentDataSense(DataSenseRequest dataSenseRequest);

}
