/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.tooling.client.internal.datasense.DataSenseResolutionScopeVisitor;

/**
 * Resolves data sense at config level.
 *
 * @since 1.0
 */
public class ConfigResolutionScope implements DataSenseResolutionScope {

  private final String muleConfigRelativeFile;

  /**
   * Creates an instance of this scope for the given config relative path.
   * @param muleConfigRelativeFile the relative file for the Mule configuration file.
   */
  public ConfigResolutionScope(String muleConfigRelativeFile) {
    requireNonNull(muleConfigRelativeFile, "muleConfigRelativeFile cannot be null");
    this.muleConfigRelativeFile = muleConfigRelativeFile;
  }

  /**
   * @return the relative path for the Mule configuration to resolve data sense.
   */
  public String getMuleConfigRelativeFile() {
    return this.muleConfigRelativeFile;
  }

  @Override
  public String toString() {
    return format("%s{muleConfigRelativeFile=%s}", getShortClassName(this.getClass()),
                  getMuleConfigRelativeFile());
  }

  @Override
  public void accept(DataSenseResolutionScopeVisitor visitor) {
    visitor.visit(this);
  }

}
