/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModelVisitor;
import org.mule.tooling.client.api.extension.model.nested.NestedChainModel;
import org.mule.tooling.client.api.extension.model.nested.NestedComponentModel;
import org.mule.tooling.client.api.extension.model.nested.NestedRouteModel;
import org.mule.tooling.client.internal.persistence.KindEnrichedTypeAdapter;
import org.mule.tooling.client.internal.persistence.Reference;

public class NestedElementModelTypeAdapter
extends KindEnrichedTypeAdapter<NestableElementModel> {
    private static final String COMPONENT_KIND = "component";
    private static final String CHAIN_KIND = "chain";
    private static final String ROUTE_KIND = "route";

    public NestedElementModelTypeAdapter(TypeAdapterFactory typeAdapterFactory, Gson gson) {
        super(typeAdapterFactory, gson);
    }

    @Override
    protected String getKind(NestableElementModel value) {
        final Reference kind = new Reference();
        value.accept(new NestableElementModelVisitor(){

            @Override
            public void visit(NestedComponentModel component) {
                kind.set(NestedElementModelTypeAdapter.COMPONENT_KIND);
            }

            @Override
            public void visit(NestedChainModel component) {
                kind.set(NestedElementModelTypeAdapter.CHAIN_KIND);
            }

            @Override
            public void visit(NestedRouteModel component) {
                kind.set(NestedElementModelTypeAdapter.ROUTE_KIND);
            }
        });
        return (String)kind.get();
    }

    @Override
    protected TypeAdapter<NestableElementModel> getDelegateAdapter(String kind) {
        Class clazz;
        switch (kind) {
            case "route": {
                clazz = NestedRouteModel.class;
                break;
            }
            case "chain": {
                clazz = NestedChainModel.class;
                break;
            }
            case "component": {
                clazz = NestedComponentModel.class;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown kind [%s] for a NestedElementModel", kind));
            }
        }
        return this.gson.getDelegateAdapter(this.typeAdapterFactory, TypeToken.get(clazz));
    }
}

