/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.exception;

import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ToolingException
extends RuntimeException {
    private String rootCauseMessage;
    private String rootCauseType;
    private String[] rootCauseStackTrace;

    public ToolingException(String message) {
        super(message);
    }

    public ToolingException(Throwable cause) {
        super(ToolingException.buildMessage(Optional.empty(), ExceptionUtils.getStackTrace((Throwable)cause)), null);
        this.setRootCauseMessage(cause);
        this.setRootCauseType(cause);
        this.setRootCauseStackTrace(cause);
    }

    public ToolingException(String message, Throwable cause) {
        super(ToolingException.buildMessage(Optional.of(message), ExceptionUtils.getStackTrace((Throwable)cause)), null);
        this.setRootCauseMessage(cause);
        this.setRootCauseType(cause);
        this.setRootCauseStackTrace(cause);
    }

    private static String buildMessage(Optional<String> message, String cause) {
        StringBuilder stringBuilder = new StringBuilder();
        message.ifPresent(stringBuilder::append);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(cause);
        return stringBuilder.toString();
    }

    private void setRootCauseMessage(Throwable cause) {
        this.rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)cause);
    }

    private void setRootCauseType(Throwable cause) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
        rootCause = rootCause == null ? cause : rootCause;
        this.rootCauseType = rootCause.getClass().getName();
    }

    private void setRootCauseStackTrace(Throwable cause) {
        this.rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)cause);
    }

    public String getRootCauseMessage() {
        return this.rootCauseMessage;
    }

    public String getRootCauseType() {
        return this.rootCauseType;
    }

    public String[] getRootCauseStackTrace() {
        return this.rootCauseStackTrace;
    }
}

