/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.metadata.type;

import org.mule.metadata.api.model.ObjectType;

/**
 * DTO for mapping a subType to the extension name that belongs to.
 */
public class SubTypeMapping {

  private String extensionName;
  private ObjectType objectType;

  public String getExtensionName() {
    return extensionName;
  }

  public void setExtensionName(String extensionName) {
    this.extensionName = extensionName;
  }

  public ObjectType getObjectType() {
    return objectType;
  }

  public void setObjectType(ObjectType objectType) {
    this.objectType = objectType;
  }

  @Override
  public String toString() {
    return "SubTypeMapping{" +
        "extensionName='" + extensionName + '\'' +
        ", objectType=" + objectType +
        '}';
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    SubTypeMapping that = (SubTypeMapping) o;

    if (!extensionName.equals(that.extensionName)) {
      return false;
    }
    return objectType.equals(that.objectType);
  }

  @Override
  public int hashCode() {
    int result = extensionName.hashCode();
    result = 31 * result + objectType.hashCode();
    return result;
  }

}
