/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.connectivity;

/**
 * Result of a test connection.
 *
 * @since 1.0
 */
public class ConnectionValidationResult {

  private boolean valid;
  private String message;
  private ErrorType errorType;
  private String exception;

  public void setValid(boolean valid) {
    this.valid = valid;
  }

  /**
   * @return {@code true} if the test connection was successful otherwise {@code false}.
   */
  public boolean isValid() {
    return valid;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  /**
   * @return {@link String} message describing the reason why the test connection failure.
   */
  public String getMessage() {
    return message;
  }

  public void setErrorType(ErrorType errorType) {
    this.errorType = errorType;
  }

  /**
   * @return {@link ErrorType} for the test connection failure.
   */
  public ErrorType getErrorType() {
    return errorType;
  }

  public void setException(String exception) {
    this.exception = exception;
  }

  /**
   * @return {@link String} with the stack trace of the exception that caused the test connection failure.
   */
  public String getException() {
    return exception;
  }

}
