/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import java.lang.reflect.Field;

/**
 * Filter to select which fields for a type should be included in the serialization when writing and reading data.
 *
 * @since 1.2
 */
public interface FieldSerializerFilter {

  /**
   * @param type the {@link Class} type to check for the field in the destination where the data will be deserialized.
   * @param field {@link Field} to check if should o should not be write/read in the serialization.
   * @return {@code true} if it has to be included in the serialization.
   * @throws ClassNotFoundException if the class is not present in the target class loader.
   */
  boolean shouldInclude(Class type, Field field) throws ClassNotFoundException;

}
