/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import static java.util.Collections.emptyList;
import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.metadata.MetadataFailure;

import java.io.Serializable;
import java.util.List;

/**
 * Immutable implementation of {@link org.mule.tooling.client.api.datasense.MetadataCache.MetadataResult}.
 *
 * @since 1.0
 */
public class ImmutableMetadataResult implements MetadataCache.MetadataResult {

  private Boolean success;
  private Serializable result;
  private List<MetadataFailure> failures = emptyList();

  /**
   * Creates an instance of this object.
   * 
   * @param success {@code true} if the metadata resolved was correctly fetched. Non null.
   * @param result the metadata result (serialized). Non null.
   * @param failures the {@link MetadataFailure failures} in case if the metadata fetched resulted in an error.
   */
  public ImmutableMetadataResult(Boolean success, Serializable result, List<MetadataFailure> failures) {
    requireNonNull(success, "success cannot be null");
    requireNonNull(result, "result cannot be null");
    this.success = success;
    this.result = result;
    this.failures = failures;
  }

  @Override
  public boolean isSuccess() {
    return success;
  }

  @Override
  public List<MetadataFailure> getFailures() {
    return failures;
  }

  @Override
  public Serializable getResult() {
    return result;
  }

}
