/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api;

import org.mule.tooling.client.api.ToolingRuntimeClient.Builder;

/**
 * Factory for creating a {@link Builder}.
 *
 * @since 1.0
 */
public interface ToolingRuntimeClientBuilderFactory {

  /**
   * Creates a {@link Builder}.
   *
   * @return {@link Builder} to create a {@link ToolingRuntimeClient}.
   */
  Builder create();

}
