/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.metadata;

import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;

import java.util.function.Consumer;

/**
 * Service for retrieving metadata.
 *
 * A {@code MetadataService}
 *
 * @since 1.0
 */
public interface MetadataService {

  /**
   * Returns a {@link MetadataResult} of {@link MetadataKeysContainer} described by {@link
   * MetadataKeysContainer#getKeys(String)}} of the associated
   * MetadataKeyProvider component identified by the given {@link MetadataKeysRequest}.
   *
   * @param metadataKeysRequest request to get the {@link MetadataKeysContainer}
   * @return Successful {@link MetadataResult} if the keys are successfully resolved Failure {@link MetadataResult} if there is an error while resolving the keys.
   * @throws ServiceUnavailableException if a connection exception happens when trying to connect to Mule Agent REST API.
   * @throws ToolingException if an unexpected error happens.
   */
  MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest)
      throws ServiceUnavailableException;

  /**
   * If supported by the {@link org.mule.tooling.client.api.ToolingRuntimeClient} implementation it will return a {@link Feature<Consumer>}
   * to do the dispose of Metadata cache on Mule Runtime side for the given location.
   * This should be called when external changes on remote system are made and metadata has to be recalculated from scratch.
   * The location could be at component level or configuration, in any case all metadata resources in cache associated to the configuration referenced
   * by the component will be disposed.
   *
   * @return {@link Feature<Action>} to execute an {@link Action} for the location of the component to be cleared, could be a configuration or a component.
   *         Either one or the other all the metadata cache entries associated to the configuration would be disposed.
   */
  Feature<Action<Location>> disposeMetadataCache();

}
