/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model;

import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.tooling.client.api.feature.Feature;

public class ErrorModel {
    private String type;
    private String namespace;
    private Feature<Boolean> handleable;
    private ErrorModel parent;

    private ErrorModel() {
    }

    public ErrorModel(String type, String namespace, boolean handleable, ErrorModel parent) {
        this.type = type;
        this.namespace = namespace;
        this.handleable = Feature.enabled(handleable);
        this.parent = parent;
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Feature<Boolean> getHandleable() {
        if (this.handleable == null) {
            this.handleable = Feature.disabled();
        }
        return this.handleable;
    }

    public Optional<ErrorModel> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return this.namespace + ":" + this.type;
    }
}

