/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import java.net.URL;
import java.util.Map;

/**
 * Factory for {@link MetadataCache}.
 *
 * @since 1.0
 */
public interface MetadataCacheFactory {

  /**
   * Create a {@link MetadataCache} for the give {@code toolingArtifactId} and {@link URL} for the artifact content.
   *
   * @param toolingArtifactId the identifier for the {@link org.mule.tooling.client.api.artifact.ToolingArtifact}.
   * @param artifactContentUrl the {@link URL} with the content of the artifact.
   * @param toolingArtifactProperties {@link Map} of tooling artifact properties for the {@link org.mule.tooling.client.api.artifact.ToolingArtifact}.
   * @return {@link MetadataCache}.
   */
  MetadataCache createMetadataCache(String toolingArtifactId, URL artifactContentUrl,
                                    Map<String, String> toolingArtifactProperties);

}
