/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.declaration.request;

import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;

import java.io.InputStream;
import java.util.List;

/**
 * Request entity for obtaining an {@link ArtifactDeclaration} instance based on its serialized representation.
 *
 * @since 1.0
 */
public final class XmlArtifactDeserializationRequest extends AbstractXmlArtifactRequest {

  private InputStream artifactSource;

  /**
   * Creates a new instance of an {@link XmlArtifactSerializationRequest}
   *
   * @param artifactSource the {@link InputStream} to the artifactSource
   * @param pluginArtifactDescriptors {@link ArtifactDescriptor artifacts} {@link List} needed by the declaration.
   */
  public XmlArtifactDeserializationRequest(InputStream artifactSource, List<ArtifactDescriptor> pluginArtifactDescriptors) {
    super(pluginArtifactDescriptors);
    this.artifactSource = artifactSource;
  }

  /**
   * @return the {@link InputStream} that contains the serialized {@link ArtifactDeclaration}
   */
  public InputStream getArtifactSource() {
    return artifactSource;
  }

}

