/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ReferenceResolver;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.StreamFactory;
import com.esotericsoftware.kryo.util.DefaultStreamFactory;
import com.esotericsoftware.kryo.util.MapReferenceResolver;
import java.util.HashMap;
import java.util.Map;
import org.mule.tooling.client.internal.serialization.ClassSerializerFilter;
import org.mule.tooling.client.internal.serialization.FieldSerializerFilter;
import org.mule.tooling.client.internal.util.Preconditions;

final class ExternalizableKryo
extends Kryo {
    private Class<?> classBeingRegistered = null;
    private final Map<Class, Registration> class2Registration = new HashMap<Class, Registration>();
    private ClassSerializerFilter classSerializerFilter;
    private FieldSerializerFilter fieldSerializerFilter;

    public ExternalizableKryo(ClassSerializerFilter classSerializerFilter, FieldSerializerFilter fieldSerializerFilter, ClassResolver classResolver) {
        super(classResolver, (ReferenceResolver)new MapReferenceResolver(), (StreamFactory)new DefaultStreamFactory());
        this.classSerializerFilter = classSerializerFilter;
        this.fieldSerializerFilter = fieldSerializerFilter;
    }

    public ExternalizableKryo(ClassResolver classResolver) {
        super(classResolver, (ReferenceResolver)new MapReferenceResolver(), (StreamFactory)new DefaultStreamFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration register(Class type, Serializer serializer) {
        this.classBeingRegistered = type;
        try {
            Registration registration = super.register(type, serializer);
            return registration;
        }
        finally {
            this.classBeingRegistered = null;
        }
    }

    public int getNextRegistrationId() {
        Preconditions.checkState(this.classBeingRegistered != null, "Cannot generate an id while no class is being registered");
        return this.classBeingRegistered.getCanonicalName().hashCode();
    }

    protected Class<?> getClassBeingRegistered() {
        return this.classBeingRegistered;
    }

    public Registration getRegistration(Class type) {
        return this.class2Registration.computeIfAbsent(type, c -> {
            Registration registration = null;
            Class searchType = type;
            while (registration == null && this.isRecurseRegistrationSearch(searchType)) {
                registration = super.getRegistration(searchType);
                if (registration.getId() == -1) {
                    registration = null;
                }
                searchType = searchType.getSuperclass();
            }
            if (registration == null) {
                Class<?> iFace;
                Class<?>[] classArray = type.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (registration = this.getRegistration(iFace = classArray[i])).getId() == -1; ++i) {
                    registration = null;
                }
            }
            return registration != null ? registration : super.getRegistration(type);
        });
    }

    private <T> boolean isRecurseRegistrationSearch(Class<T> searchType) {
        return searchType != null && !Enum.class.isAssignableFrom(searchType) && !Object.class.equals(searchType);
    }

    public ClassSerializerFilter getClassSerializerFilter() {
        return this.classSerializerFilter;
    }

    public FieldSerializerFilter getFieldSerializerFilter() {
        return this.fieldSerializerFilter;
    }
}

