/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.operation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.OutputModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyIdModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

public class OperationModel
implements ComponentModel {
    private String name;
    private String description;
    private List<ParameterGroupModel> parameterGroupModels;
    private DisplayModel displayModel;
    private boolean blocking;
    private Set<ErrorModel> errors;
    private OutputModel output;
    private OutputModel outputAttributes;
    private boolean transaction;
    private boolean requiresConnection;
    private boolean supportsStreaming;
    private StereotypeModel stereotype;
    private List<? extends NestableElementModel> nestedComponents;
    private MetadataKeyIdModel metadataKeyIdModel;

    protected OperationModel() {
    }

    public OperationModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, boolean blocking, Set<ErrorModel> errors, OutputModel output, OutputModel outputAttributes, boolean transaction, boolean requiresConnection, boolean supportsStreaming, StereotypeModel stereotype, List<? extends NestableElementModel> nestedComponents, MetadataKeyIdModel metadataKeyIdModel) {
        this.name = name;
        this.description = description;
        this.parameterGroupModels = parameterGroupModels;
        this.displayModel = displayModel;
        this.blocking = blocking;
        this.errors = errors;
        this.output = output;
        this.outputAttributes = outputAttributes;
        this.transaction = transaction;
        this.requiresConnection = requiresConnection;
        this.supportsStreaming = supportsStreaming;
        this.stereotype = stereotype;
        this.nestedComponents = nestedComponents;
        this.metadataKeyIdModel = metadataKeyIdModel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        return this.errors;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public OutputModel getOutput() {
        return this.output;
    }

    public OutputModel getOutputAttributes() {
        return this.outputAttributes;
    }

    public boolean isTransactional() {
        return this.transaction;
    }

    public boolean requiresConnection() {
        return this.requiresConnection;
    }

    public boolean supportsStreaming() {
        return this.supportsStreaming;
    }

    @Override
    public StereotypeModel getStereotype() {
        return this.stereotype;
    }

    @Override
    public List<? extends NestableElementModel> getNestedComponents() {
        return this.nestedComponents;
    }

    public Optional<MetadataKeyIdModel> getMetadataKeyIdModel() {
        return Optional.ofNullable(this.metadataKeyIdModel);
    }

    public Optional<ParameterGroupModel> getParameterGroupModel(String name) {
        return this.parameterGroupModels.stream().filter(model -> model.getName().equals(name)).findFirst();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((OperationModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

