/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.metadata;

import java.util.Set;

/**
 * This key can be contributed with a display name and user defined properties.
 * <p>
 * Also this {@link MetadataKey} can be composed by other {@link MetadataKey MetadataKeys}
 * to form a composed key.
 *
 * @since 1.0
 */
public final class MetadataKey {

  private String id;
  private String displayName;
  private String partName;
  private Set<MetadataKey> childs;

  public MetadataKey(String id, String displayName, Set<MetadataKey> childs, String partName) {
    this.id = id;
    this.displayName = displayName;
    this.childs = childs;
    this.partName = partName;
  }

  /**
   * @return identifier for the current key
   */
  public String getId() {
    return id;
  }

  /**
   * @return human readable name to use when displaying the key
   */
  public String getDisplayName() {
    return displayName;
  }

  /**
   * @return the child {@link MetadataKey MetadataKeys} that form a composed {@link MetadataKey}.
   */
  public Set<MetadataKey> getChilds() {
    return childs;
  }

  /**
   * @return the name of the part which this {@link MetadataKey} is from
   */
  public String getPartName() {
    return partName;
  }
}
