/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import static java.util.Optional.ofNullable;
import static org.apache.commons.lang3.builder.EqualsBuilder.reflectionEquals;
import static org.apache.commons.lang3.builder.HashCodeBuilder.reflectionHashCode;
import static org.mule.tooling.client.api.feature.Feature.disabled;
import static org.mule.tooling.client.api.feature.Feature.enabled;
import org.mule.tooling.client.api.feature.Feature;

import java.util.Optional;

/**
 * A model which represents a possible error that could be thrown
 * by the component represented by the component models.
 *
 * @since 1.0
 */
public class ErrorModel {

  private String type;
  private String namespace;
  private Feature<Boolean> handleable;
  private ErrorModel parent;

  // Just needed in order to serialize this object
  private ErrorModel() {}

  public ErrorModel(String type, String namespace, boolean handleable, ErrorModel parent) {
    this.type = type;
    this.namespace = namespace;
    this.handleable = enabled(handleable);
    this.parent = parent;
  }

  public String getType() {
    return this.type;
  }

  public String getNamespace() {
    return this.namespace;
  }

  public Feature<Boolean> getHandleable() {
    if (handleable == null) {
      handleable = disabled();
    }
    return handleable;
  }

  public Optional<ErrorModel> getParent() {
    return ofNullable(this.parent);
  }

  public int hashCode() {
    return reflectionHashCode(this);
  }

  public boolean equals(Object obj) {
    return reflectionEquals(this, obj);
  }

  public String toString() {
    return this.namespace + ":" + this.type;
  }

}
