/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.JsonMetadataTypeWriter;
import org.mule.metadata.persistence.SerializationContext;
import org.mule.tooling.client.api.extension.model.Category;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.ExternalLibraryModel;
import org.mule.tooling.client.api.extension.model.ImportedTypeModel;
import org.mule.tooling.client.api.extension.model.SubTypesModel;
import org.mule.tooling.client.api.extension.model.XmlDslModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.function.FunctionModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.internal.persistence.ErrorModelSerializerDelegate;

public final class ExtensionModelTypeAdapter
extends TypeAdapter<ExtensionModel> {
    private static final String CONFIGURATIONS = "configurations";
    private static final String OPERATIONS = "operations";
    private static final String FUNCTIONS = "functions";
    private static final String CONSTRUCTS = "constructs";
    private static final String CONNECTION_PROVIDERS = "connectionProviders";
    private static final String MESSAGE_SOURCES = "messageSources";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String MIN_MULE_VERSION = "minMuleVersion";
    private static final String VERSION = "version";
    private static final String VENDOR = "vendor";
    private static final String CATEGORY = "category";
    private static final String TYPES = "types";
    private static final String RESOURCES = "resources";
    private static final String XML_DSL = "xmlDsl";
    private static final String SUB_TYPES = "subTypes";
    private static final String EXTERNAL_LIBRARIES = "externalLibraries";
    private static final String DISPLAY_MODEL = "displayModel";
    private static final String IMPORTED_TYPES = "importedTypes";
    static final String ERRORS = "errors";
    private final Gson gsonDelegate;
    private final JsonMetadataTypeLoader typeLoader = new JsonMetadataTypeLoader();
    private final JsonMetadataTypeWriter typeWriter = new JsonMetadataTypeWriter();
    private final SerializationContext serializationContext;
    private final ErrorModelSerializerDelegate errorModelDelegate;

    public ExtensionModelTypeAdapter(Gson gsonDelegate, SerializationContext serializationContext, Map<String, ErrorModel> errorModelMap) {
        this.gsonDelegate = gsonDelegate;
        this.serializationContext = serializationContext;
        this.errorModelDelegate = new ErrorModelSerializerDelegate(errorModelMap);
    }

    public void write(JsonWriter out, ExtensionModel model) throws IOException {
        out.beginObject();
        out.name(NAME).value(model.getName());
        out.name(DESCRIPTION).value(model.getDescription());
        out.name(MIN_MULE_VERSION).value(model.getMinMuleVersion());
        out.name(VERSION).value(model.getVersion());
        out.name(VENDOR).value(model.getVendor());
        this.writeWithDelegate(model.getCategory(), CATEGORY, out, new TypeToken<Category>(){});
        this.writeWithDelegate(model.getXmlDslModel(), XML_DSL, out, new TypeToken<XmlDslModel>(){});
        this.writeWithDelegate(model.getResources(), RESOURCES, out, new TypeToken<Set<String>>(){});
        this.writeWithDelegate(model.getSubTypes(), SUB_TYPES, out, new TypeToken<Set<SubTypesModel>>(){});
        this.writeWithDelegate(model.getExternalLibraryModels(), EXTERNAL_LIBRARIES, out, new TypeToken<Set<ExternalLibraryModel>>(){});
        this.writeImportedTypes(out, model.getImportedTypes());
        this.writeWithDelegate(model.getDisplayModel().orElse(null), DISPLAY_MODEL, out, new TypeToken<DisplayModel>(){});
        this.writeWithDelegate(model.getConfigurationModels(), CONFIGURATIONS, out, new TypeToken<List<ConfigurationModel>>(){});
        this.writeWithDelegate(model.getOperationModels(), OPERATIONS, out, new TypeToken<List<OperationModel>>(){});
        this.writeWithDelegate(model.getFunctionModels(), FUNCTIONS, out, new TypeToken<List<FunctionModel>>(){});
        this.writeWithDelegate(model.getConstructModels(), CONSTRUCTS, out, new TypeToken<List<ConstructModel>>(){});
        this.writeWithDelegate(model.getConnectionProviders(), CONNECTION_PROVIDERS, out, new TypeToken<List<ConnectionProviderModel>>(){});
        this.writeWithDelegate(model.getSourceModels(), MESSAGE_SOURCES, out, new TypeToken<List<SourceModel>>(){});
        this.errorModelDelegate.writeErrors(model.getErrorModels(), out);
        this.writeTypes(TYPES, out, model.getTypes());
        out.endObject();
    }

    public ExtensionModel read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        Set<ObjectType> types = this.parseTypes(TYPES, json);
        JsonArray errors = json.get(ERRORS).getAsJsonArray();
        this.errorModelDelegate.parseErrors(errors);
        Set<ImportedTypeModel> importedTypes = this.parseImportedTypes(json);
        Set<String> resources = this.parseWithDelegate(json, RESOURCES, new TypeToken<Set<String>>(){});
        Set<SubTypesModel> subTypes = this.parseWithDelegate(json, SUB_TYPES, new TypeToken<Set<SubTypesModel>>(){});
        Set<ExternalLibraryModel> externalLibraries = this.parseWithDelegate(json, EXTERNAL_LIBRARIES, new TypeToken<Set<ExternalLibraryModel>>(){});
        List<ConfigurationModel> configs = this.parseWithDelegate(json, CONFIGURATIONS, new TypeToken<List<ConfigurationModel>>(){});
        List<OperationModel> operations = this.parseWithDelegate(json, OPERATIONS, new TypeToken<List<OperationModel>>(){});
        List<ConnectionProviderModel> providers = this.parseWithDelegate(json, CONNECTION_PROVIDERS, new TypeToken<List<ConnectionProviderModel>>(){});
        List<SourceModel> sources = this.parseWithDelegate(json, MESSAGE_SOURCES, new TypeToken<List<SourceModel>>(){});
        List<FunctionModel> functions = this.parseWithDelegate(json, FUNCTIONS, new TypeToken<List<FunctionModel>>(){});
        List<ConstructModel> constructs = this.parseWithDelegate(json, CONSTRUCTS, new TypeToken<List<ConstructModel>>(){});
        return new ExtensionModel(json.get(NAME).getAsString(), (Category)this.gsonDelegate.fromJson(json.get(CATEGORY), Category.class), json.get(VENDOR).getAsString(), resources, importedTypes, subTypes, types, json.get(MIN_MULE_VERSION).getAsString(), json.get(VERSION).getAsString(), (XmlDslModel)this.gsonDelegate.fromJson(json.get(XML_DSL), XmlDslModel.class), json.get(DESCRIPTION).getAsString(), (DisplayModel)this.gsonDelegate.fromJson(json.get(DISPLAY_MODEL), DisplayModel.class), externalLibraries, configs, operations, providers, sources, functions, constructs, this.errorModelDelegate.getErrors());
    }

    private <T> T parseWithDelegate(JsonObject json, String elementName, TypeToken<T> typeToken) {
        JsonElement element = json.get(elementName);
        if (element != null) {
            return (T)this.gsonDelegate.fromJson(element, typeToken.getType());
        }
        return null;
    }

    private <T> void writeWithDelegate(T value, String elementName, JsonWriter out, TypeToken<T> typeToken) throws IOException {
        out.name(elementName);
        this.gsonDelegate.toJson(value, typeToken.getType(), out);
    }

    private Set<ObjectType> parseTypes(String label, JsonObject json) {
        LinkedHashSet<ObjectType> types = new LinkedHashSet<ObjectType>();
        JsonArray typesArray = json.get(label).getAsJsonArray();
        if (typesArray == null) {
            return Collections.emptySet();
        }
        typesArray.forEach(typeElement -> this.typeLoader.load(typeElement).ifPresent(type -> {
            if (!(type instanceof ObjectType)) {
                throw new IllegalArgumentException(String.format("Was expecting an object type but %s was found instead", type.getClass().getSimpleName()));
            }
            JavaTypeUtils.getId((MetadataType)type).orElseThrow(() -> new IllegalArgumentException("Invalid json element found in 'types', only ObjectTypes with a 'typeId' can be part of the 'types' catalog"));
            ObjectType objectType = (ObjectType)type;
            this.serializationContext.registerObjectType(objectType);
            types.add(objectType);
        }));
        return types;
    }

    private Set<ImportedTypeModel> parseImportedTypes(JsonObject json) {
        return this.parseTypes(IMPORTED_TYPES, json).stream().map(ImportedTypeModel::new).collect(Collectors.toSet());
    }

    private void writeTypes(String label, JsonWriter out, Set<ObjectType> additionalTypes) throws IOException {
        out.name(label);
        out.beginArray();
        LinkedHashSet<ObjectType> objectTypes = new LinkedHashSet<ObjectType>();
        objectTypes.addAll(additionalTypes);
        for (ObjectType type : objectTypes) {
            this.typeWriter.write((MetadataType)type, out);
        }
        out.endArray();
    }

    private void writeImportedTypes(JsonWriter out, Set<ImportedTypeModel> importedTypeModels) throws IOException {
        this.writeTypes(IMPORTED_TYPES, out, importedTypeModels.stream().map(ImportedTypeModel::getImportedType).collect(Collectors.toCollection(LinkedHashSet::new)));
    }
}

