/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.util.ReflectionUtils;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.tooling.client.internal.persistence.Reference;

public class DefaultArrayTypeConverter
implements Converter {
    private final Mapper mapper;

    public DefaultArrayTypeConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        DefaultArrayType defaultArrayType = (DefaultArrayType)source;
        writer.startNode("type");
        String typeName = this.mapper.serializedClass(defaultArrayType.getType().getClass());
        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)typeName, defaultArrayType.getType().getClass());
        context.convertAnother((Object)defaultArrayType.getType());
        writer.endNode();
        writer.endNode();
        writer.startNode("metadata-format");
        context.convertAnother((Object)defaultArrayType.getMetadataFormat());
        writer.endNode();
        writer.startNode("annotations");
        try {
            context.convertAnother(ReflectionUtils.getValueIncludingSuperclasses((String)"annotations", (Object)defaultArrayType));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while getting attributes for defaultArrayType using reflection", e);
        }
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Reference<MetadataType> typeReference = new Reference<MetadataType>();
        MetadataFormat metadataFormat = null;
        Map typeAnnotations = null;
        DefaultArrayType current = new DefaultArrayType(null, null, null);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("metadata-format".equals(reader.getNodeName())) {
                metadataFormat = (MetadataFormat)context.convertAnother((Object)current, MetadataFormat.class);
            } else if ("annotations".equals(reader.getNodeName())) {
                typeAnnotations = (Map)context.convertAnother((Object)current, LinkedHashMap.class);
            } else if ("type".equals(reader.getNodeName())) {
                reader.moveDown();
                Class type = HierarchicalStreams.readClassType((HierarchicalStreamReader)reader, (Mapper)this.mapper);
                typeReference.set((MetadataType)context.convertAnother((Object)current, type));
                reader.moveUp();
            }
            reader.moveUp();
        }
        try {
            ReflectionUtils.setVariableValueInObject((Object)current, (String)"type", () -> (MetadataType)typeReference.get());
            ReflectionUtils.setVariableValueInObject((Object)current, (String)"metadataFormat", metadataFormat);
            ReflectionUtils.setVariableValueInObject((Object)current, (String)"annotations", typeAnnotations);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while setting attributes for defaultArrayType using reflection", e);
        }
        return current;
    }

    public boolean canConvert(Class type) {
        return DefaultArrayType.class.isAssignableFrom(type);
    }
}

