/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.configuration.agent;

import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.configuration.ssl.SslConfiguration;

public class ImmutableAgentConfiguration
implements AgentConfiguration {
    private URL toolingApiUrl;
    private long defaultConnectionTimeout;
    private long defaultReadTimeout;
    private SslConfiguration sslConfiguration;

    public ImmutableAgentConfiguration(URL toolingApiUrl, long defaultConnectionTimeout, long defaultReadTimeout, SslConfiguration sslConfiguration) {
        this.toolingApiUrl = toolingApiUrl;
        this.defaultConnectionTimeout = defaultConnectionTimeout;
        this.defaultReadTimeout = defaultReadTimeout;
        this.sslConfiguration = sslConfiguration;
    }

    @Override
    public URL getToolingApiUrl() {
        return this.toolingApiUrl;
    }

    @Override
    public long getDefaultConnectTimeout() {
        return this.defaultConnectionTimeout;
    }

    @Override
    public long getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    @Override
    public Optional<SslConfiguration> getSslConfiguration() {
        return Optional.ofNullable(this.sslConfiguration);
    }

    public String toString() {
        return String.format("%s{toolingApiUrl=%s,defaultConnectionTimeout=%sms, defaultReadTimeout=%sms}", ClassUtils.getShortClassName(this.getClass()), this.toolingApiUrl, this.defaultConnectionTimeout, this.defaultReadTimeout);
    }
}

