/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.dataweave;

/**
 * Represents the information about DataWeave modules.
 *
 * @since 1.0
 */
public class DataWeaveModuleOption {

  private String name;
  private String type;
  private String defaultValue;
  private String description;
  private String possibleValues;

  public DataWeaveModuleOption() {
    super();
  }

  public DataWeaveModuleOption(String defaultValue, String description, String name, String possibleValues, String type) {
    this.defaultValue = defaultValue;
    this.description = description;
    this.name = name;
    this.possibleValues = possibleValues;
    this.type = type;
  }

  public String getDefaultValue() {
    return defaultValue;
  }

  public void setDefaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getPossibleValues() {
    return possibleValues;
  }

  public void setPossibleValues(String possibleValues) {
    this.possibleValues = possibleValues;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }
}
