/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.configuration.ssl;

import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.mule.tooling.client.api.configuration.ssl.KeyStoreConfig;
import org.mule.tooling.client.api.configuration.ssl.SslConfiguration;
import org.mule.tooling.client.api.configuration.ssl.TrustStoreConfig;

public class ImmutableSslConfiguration
implements SslConfiguration {
    private final KeyStoreConfig keyStoreConfig;
    private final TrustStoreConfig trustStoreConfig;

    public ImmutableSslConfiguration(KeyStoreConfig keyStoreConfig, TrustStoreConfig trustStoreConfig) {
        Objects.requireNonNull(keyStoreConfig, "keyStoreConfig cannot be null");
        Objects.requireNonNull(trustStoreConfig, "trustStoreConfig cannot be null");
        this.keyStoreConfig = keyStoreConfig;
        this.trustStoreConfig = trustStoreConfig;
    }

    @Override
    public KeyStoreConfig getKeyStoreConfig() {
        return this.keyStoreConfig;
    }

    @Override
    public TrustStoreConfig getTrustStoreConfig() {
        return this.trustStoreConfig;
    }

    public String toString() {
        return String.format("%s{keyStoreConfig=%s, trustStoreConfig=%s}", ClassUtils.getShortClassName(this.getClass()), this.keyStoreConfig, this.trustStoreConfig);
    }
}

