/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.descriptors;

import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;

public final class ArtifactDescriptor {
    private static final String JAR = "jar";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ArtifactDescriptor(String groupId, String artifactId, String version, String classifier, String extension) {
        Objects.requireNonNull(groupId, "groupId");
        Objects.requireNonNull(artifactId, "artifactId");
        Objects.requireNonNull(version, "version");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension == null ? JAR : extension;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactDescriptor artifactDescriptor = (ArtifactDescriptor)o;
        if (!this.groupId.equals(artifactDescriptor.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(artifactDescriptor.artifactId)) {
            return false;
        }
        if (!this.version.equals(artifactDescriptor.version)) {
            return false;
        }
        return this.extension.equals(artifactDescriptor.extension);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s{groupId=%s,artifactId=%s,version=%s,extension=%s}", ClassUtils.getShortClassName(this.getClass()), this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getExtension());
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String extension;
        private String version;
        private String classifier;

        public Builder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder withExtension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public ArtifactDescriptor build() {
            return new ArtifactDescriptor(this.groupId, this.artifactId, this.version, this.classifier, this.extension);
        }
    }
}

