/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.extension.model.ExpressionSupport;
import org.mule.tooling.client.api.extension.model.PathModelLocation;
import org.mule.tooling.client.api.extension.model.PathModelType;
import org.mule.tooling.client.api.extension.model.parameter.ParameterRole;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

/**
 * {@link TypeAdapterFactory} for {@link AgentConfiguration}.
 *
 * @since 1.0
 */
public class TypeAnnotationSerializerExtenderTypeAdapterFactory implements TypeAdapterFactory {

  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (PathModelType.class.isAssignableFrom(type.getRawType())) {
      return (TypeAdapter<T>) new PathModelTypeTypeAdapter();
    }
    if (ParameterRole.class.isAssignableFrom(type.getRawType())) {
      return (TypeAdapter<T>) new ParameterRoleTypeAdapter();
    }
    if (ExpressionSupport.class.isAssignableFrom(type.getRawType())) {
      return (TypeAdapter<T>) new ExpressionSupportTypeAdapter();
    }
    if (PathModelLocation.class.isAssignableFrom(type.getRawType())) {
      return (TypeAdapter<T>) new PathModelLocationTypeAdapter();
    }

    return null;
  }
}
