/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import static org.mule.tooling.client.api.extension.model.PathModelType.anyPathModelType;
import static org.mule.tooling.client.api.extension.model.PathModelType.directoryPathModelType;
import static org.mule.tooling.client.api.extension.model.PathModelType.filePathModelType;
import org.mule.tooling.client.api.extension.model.PathModelType;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;

/**
 * {@link TypeAdapter} for {@link PathModelType}.
 */
public class PathModelTypeTypeAdapter extends TypeAdapter<PathModelType> {

  @Override
  public void write(JsonWriter out, PathModelType pathModelType) throws IOException {
    out.value(pathModelType.getValue());
  }

  @Override
  public PathModelType read(JsonReader in) throws IOException {
    String type = in.nextString();
    switch (type) {
      case "DIRECTORY":
        return directoryPathModelType(type);
      case "FILE":
        return filePathModelType(type);
      case "ANY":
        return anyPathModelType(type);
      default:
        return new PathModelType(type);
    }
  }

}
