/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.dsl;

import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.extension.model.ExtensionModel;

/**
 * Factory for creating {@link DslSyntaxResolver} using set of plugins that compose the DslResolvingContext
 * in which {@code this} factory was created.
 *
 * @since 1.0
 */
public interface DslSyntaxResolverFactory extends Disposable {

  /**
   * Creates a new {@link DslSyntaxResolver} for the given {@link ExtensionModel} using the DslResolvingContext associated
   * to {@code this} factory instance.
   *
   * @param extensionModel the {@link ExtensionModel} whose components DSL will be resolved.
   *                       This model provides, for example, the default namespace of all the components.
   * @return a new instance of a {@link DslSyntaxResolver} for the given {@link ExtensionModel}
   */
  DslSyntaxResolver createDslResolver(ExtensionModel extensionModel);

}
